*********************************************************************
8/23/07: I converted this to a macro and added the tax variables.

THESE NOTES WERE IN THE PROGRAM, BUT FOR SOME REASON, THIS SCREWS UP
THE MACRO, SO I'VE MOVED THEM TO THE TOP

* 1988 uses the Rewrite Sample

*primary families (ftype=1), related subfamilies (ftype=3)

NOTE that the variable that is named ftype after 1987 is called 
fkind in 1987 and before.

DEFINE SM'S AS:
	never married, divorced, separated, or widowed
	at least one own never-married kid under 18
	primary families or unrelated subfamilies 

**********************************************************************;

options obs=max mprint;

%macro clean8890(yr);

proc sort data=cpsdata.all&yr;
by hseq;
run;

data poverty;
merge cpsdata.all&yr(in=in1) noncash.hous&yr;
by hseq;
if in1;
id=pseq*100+ppos;
run;

proc sort data=poverty;
by famid;
run;

data temp;
set noncash.fam&yr;
famid=pseq*100+(ffposold-40);
run;
proc means;
run;

proc sort data=temp;
by famid;
run;

data poverty;
merge poverty(in=in1) temp;
by famid;
if in1;
run;

data temp;
set noncash.pers&yr;
ppos=ppposold+40;
run;
proc means;
run;
proc sort data=temp;
by pseq ppos;
run;
proc sort data=poverty;
by pseq ppos;
run;
data poverty;
merge poverty(in=in1) temp;
by pseq ppos;
if in1;

	  tottax=fedtax+statetax+fica-eitc;
	  lft5=floor(famid/100);

	  IF sur_sc1=5 THEN rr1=1;
		ELSE rr1=0;
	  IF sur_sc2=5 THEN rr2=1;
		ELSE rr2=0;
	  railroad=sur_val1*rr1+sur_val2*rr2;
	  ssinc_rr=ssinc+railroad;

	  tot_trans=ssinc+uiinc+wcinc+vetinc+pawval+ssi+railroad;

	IF mcaid=1 THEN mcaid_yes=1;
  		 ELSE mcaid_yes=0;

	IF 0 LE age LE 4 THEN kid_0_4=1;
		 ELSE kid_0_4=0;

	IF age=0 THEN infant=1;
   		 ELSE infant=0;

	IF famrel IN (1,2) AND sex=2 THEN pot_wic_mom=1;
	   ELSE pot_wic_mom=0;

run;



PROC SORT DATA=poverty;
   BY id;
RUN;
PROC SORT DATA=taxsim.taxs&yr;
   BY id;
RUN;
DATA poverty;
MERGE poverty(IN=in1) taxsim.taxs&yr(DROP=year);
BY id;
IF in1;

ts_tottax=ftl+stl+(ts_fica/2);

run;

PROC SORT DATA=poverty;
   BY famid;
RUN;
proc means sum noprint data=poverty;
   by famid;
   var ts_tottax;
   output out=tmp1(drop= _type_ _freq_) sum=ftax_nonprime;
run;

DATA poverty;
MERGE poverty(IN=in1) tmp1(KEEP=famid ftax_nonprime);
BY famid;
IF in1;
run;

PROC SORT DATA=poverty;
   BY hseq;
RUN;
proc means sum noprint data=poverty;
   by hseq;
   where ftype IN(1,3);
   var ts_tottax;
   output out=tmp2(drop= _type_ _freq_) sum=ftax_prime;
run;
proc means sum noprint data=poverty;
   by hseq;
   var ts_tottax;
   output out=tmp3(drop= _type_ _freq_) sum=hts_tottax;
run;

DATA poverty;
MERGE poverty(IN=in1) tmp2(KEEP=hseq ftax_prime) tmp3(KEEP=hseq hts_tottax);
BY hseq;
IF in1;

IF ftype IN(1,3) THEN fts_tottax=ftax_prime;
   ELSE fts_tottax=ftax_nonprime;

run;



proc sort data=poverty;
by famid;
run;

data temp1;
set poverty;
by famid;
if first.famid;
   IF marstat IN (4,5,6,7) AND fownu18 GT 0 AND ftype IN (1,4) 
      and sex=2 and 18 LE age LE 54 then sm_f=1;
   ELSE sm_f=0;
keep year sm_f ftype fkind hseq famid refrel2;
run;
DATA poverty;
MERGE poverty(IN=in1) temp1(keep=famid sm_f) ;
by famid;
run;

proc sort data=poverty;
by hseq;
run;

proc means max noprint data=poverty;
by hseq;
var refrel2 ftype;
   output out=temp3 max=fammax typemax;
run;

data temp2;
set temp1(rename=(sm_f=sm_h));
   IF ftype=1;
run;


proc sort data=temp2;
by hseq;
run;

DATA poverty;
MERGE poverty(IN=in1) temp2(keep=hseq sm_h) temp3(keep=hseq fammax typemax);
by hseq;
   IF ftype ne 3 then sm=sm_f;
   ELSE IF ftype=3 then sm=sm_h;

   IF ftype=1 and sm=1 and fammax LE 5 and typemax=1 then smlone=1;
   ELSE smlone=0;
   
run;


proc means sum noprint data=poverty;
   by famid;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr mcaid_yes kid_0_4 wkswrk infant pot_wic_mom pawval;
   output out=temp sum=ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr
					   fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval;
run;
data poverty;
   merge poverty 
         temp (keep=famid ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr 
					fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval);
   by famid;

   fwic_mom=MIN(fpot_wic_mom,finfant,1);

   IF famrel IN (1,2) AND sex=2 AND finfant GT 0 THEN wic_mom=1;
      ELSE wic_mom=0;
 
run;

data temp;
   set poverty; 
   if ftype=1;
run;

data temp;
   set temp; 
   by famid notsorted;
   if first.famid=1 then dummy=1;
   else dummy=0;
   if dummy=1;
keep lft5 ftotval fmvfs fhoussub fmvrsl fngmcare fngmcaid ftotearn fpersons frelu18;
run;

proc sort data=poverty;
by lft5;
run;
proc sort data=temp;
by lft5;
run;

data poverty;
merge poverty temp(rename=(ftotval=ftotval_new fmvfs=fmvfs_new
     fhoussub=fhoussub_new fmvrsl=fmvrsl_new 
     fngmcare=fngmcare_new fngmcaid=fngmcaid_new ftotearn=ftotearn_new fpersons=fpersons_new 
     frelu18=frelu18_new));
by lft5;

if ftype=3 then do;
  	 ftotval_final=ftotval_new;
     fmvfs_final=fmvfs_new;
         fhoussub_final=fhoussub_new; 
         fmvrsl_final=fmvrsl_new;
         fngmcare_final=fngmcare_new; 
         fngmcaid_final=fngmcaid_new;
         ftotearn_final=ftotearn_new; 
		 fpersons_final=fpersons_new;
	     frelu18_final=frelu18_new; 
end;
else if ftype ne 3 then do;
        ftotval_final=ftotval;
        fmvfs_final=fmvfs;
         fhoussub_final=fhoussub; 
         fmvrsl_final=fmvrsl;
         fngmcare_final=fngmcare; 
         fngmcaid_final=fngmcaid; 
		 ftotearn_final=ftotearn; 
		 fpersons_final=fpersons;
	     frelu18_final=frelu18; 
end;

run;

proc means sum noprint data=poverty;
by lft5;
where ftype in(1,3);
var tottax eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr mcaid_yes kid_0_4 wkswrk pawval wic_mom infant;
output out=temp sum=ftottax2 feitc2 fcapgain2 fcaploss2 femcontrb2 ftot_trans2 fssinc_rr2
					fmcaid2 fkid_0_42 fwkswrk2 fpawval2 fwic_mom2 finfant2;
run;

data poverty;
merge poverty temp (keep=lft5 ftottax2 feitc2 fcapgain2 fcaploss2 femcontrb2 ftot_trans2 fssinc_rr2
						 fmcaid2 fkid_0_42 fwkswrk2 fpawval2 fwic_mom2 finfant2);
by lft5; 

if ftype in (1,3) then do;
   ftottax_final=ftottax2;
   feitc_final=feitc2;
	fcapgain_final=fcapgain2;
     fcaploss_final=fcaploss2;
     femcontrb_final=femcontrb2;
	 ftot_trans_final=ftot_trans2;
	 fssinc_rr_final=fssinc_rr2;

	 fmcaid_final= fmcaid2;
	 fkid_0_4_final= fkid_0_42;
	 fwkswrk_final=fwkswrk2;
	 fpawval_final=fpawval2;
	 fwic_mom_final=fwic_mom2;
	 finfant_final=finfant2;
end;
else if ftype in (2,4,5) then do;
   ftottax_final=ftottax;
   feitc_final=feitc;
	fcapgain_final=fcapgain;
     fcaploss_final=fcaploss;
     femcontrb_final=femcontrb;
	 ftot_trans_final=ftot_trans;
	 fssinc_rr_final=fssinc_rr;

	 fmcaid_final= fmcaid;
	 fkid_0_4_final= fkid_0_4;
	 fwkswrk_final=fwkswrk;
	 fpawval_final=fpawval;
	 fwic_mom_final=fwic_mom;
	 finfant_final=finfant;
end;

run;

data temp;
   set poverty;
   by famid;
   if first.famid; 
run;
proc sort data=temp;
   by hseq;
run;

proc means sum noprint data=temp;
   by hseq;
   where ftype NE 3;
   var fmvfs fhoussub fmvrsl fngmcare fngmcaid ftotearn fpersons frelu18;
   output out=temp1 sum=hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18;
run;

proc sort data=poverty;
   by hseq;
run;
proc means sum noprint data=poverty;
   by hseq;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr;
   output out=temp sum=htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr;
run;

data cpsdata.poverty&yr;
   merge poverty 
         temp (keep= hseq htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr)
		 temp1 (keep=hseq hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18);
   by hseq; 
run;
proc means;
run;


%mend;

%clean8890(1988);
%clean8890(1989);
%clean8890(1990);

proc compare base=cpsdata.poverty1988_bak
             compare=cpsdata.poverty1988
			 novalues listall
;

run;
proc compare base=cpsdata.poverty1988_bak(DROP=rsnnotl wagesal1 selfemp1 farm1 socsec)
             compare=cpsdata.poverty1988(DROP=ssinc divinc uiinc alimony ptotinc ptotearn retinc intinc
											rsnnotl wagesal1 selfemp1 farm1)
			 novalues listall
;

run;


*********************************************************************
1991
**********************************************************************;

*********************************************************************
* 1991 Different b/c get noncash stufff from unicon
First merge in tax and noncash benefit data
**********************************************************************;
proc sort data=cpsdata.all1991;
by pseq ppos;
run;
* noncash data for 1991 is from unicon and all variables are already retained at individual level;
proc sort data=noncash.pers1991;
by pseq ppos;
run;
data poverty;
merge cpsdata.all1991(in=in1) noncash.pers1991;
by pseq ppos;
if in1;
	  tottax=fedtax+statetax+fica-eitc;
	  lft5=floor(famid/100);

	  IF sur_sc1=5 THEN rr1=1;
		ELSE rr1=0;
	  IF sur_sc2=5 THEN rr2=1;
		ELSE rr2=0;
	  railroad=sur_val1*rr1+sur_val2*rr2;
	  ssinc_rr=ssinc+railroad;

	  tot_trans=ssinc+uiinc+wcinc+vetinc+pawval+ssi+railroad;

	IF mcaid=1 THEN mcaid_yes=1;
  		 ELSE mcaid_yes=0;

	IF 0 LE age LE 4 THEN kid_0_4=1;
		 ELSE kid_0_4=0;

	IF age=0 THEN infant=1;
   		 ELSE infant=0;

	IF famrel IN (1,2) AND sex=2 THEN pot_wic_mom=1;
	   ELSE pot_wic_mom=0;

      
* return on home equity is missing for about 900 obs in unicon, not sure why;
housret2=housret;
if housret=. then housret=0;
id=pseq*100+ppos;
run;


PROC SORT DATA=poverty;
   BY id;
RUN;
PROC SORT DATA=taxsim.taxs1991;
   BY id;
RUN;
DATA poverty;
MERGE poverty(IN=in1) taxsim.taxs1991(DROP=year);
BY id;
IF in1;

ts_tottax=ftl+stl+(ts_fica/2);

run;

PROC SORT DATA=poverty;
   BY famid;
RUN;
proc means sum noprint data=poverty;
   by famid;
   var ts_tottax;
   output out=tmp1(drop= _type_ _freq_) sum=ftax_nonprime;
run;

DATA poverty;
MERGE poverty(IN=in1) tmp1(KEEP=famid ftax_nonprime);
BY famid;
IF in1;
run;

PROC SORT DATA=poverty;
   BY hseq;
RUN;
proc means sum noprint data=poverty;
   by hseq;
   where ftype IN(1,3);
   var ts_tottax;
   output out=tmp2(drop= _type_ _freq_) sum=ftax_prime;
run;
proc means sum noprint data=poverty;
   by hseq;
   var ts_tottax;
   output out=tmp3(drop= _type_ _freq_) sum=hts_tottax;
run;

DATA poverty;
MERGE poverty(IN=in1) tmp2(KEEP=hseq ftax_prime) tmp3(KEEP=hseq hts_tottax);
BY hseq;
IF in1;

IF ftype IN(1,3) THEN fts_tottax=ftax_prime;
   ELSE fts_tottax=ftax_nonprime;

run;

*Create single mother indicators;
proc sort data=poverty;
by famid;
run;

data temp1;
set poverty;
by famid;
if first.famid;
   IF marstat IN (4,5,6,7) AND fownu18 GT 0 AND ftype IN (1,4) 
      and sex=2 and 18 LE age LE 54 then sm_f=1;
   ELSE sm_f=0;
/* never married, divorced, separated, or widowed */
/* at least one own never-married kid under 18 */
/* primary families or unrelated subfamilies */
keep year sm_f ftype fkind hseq famid refrel2;
run;
*get identifiers for primary families without other adults or other families;
DATA poverty;
MERGE poverty(IN=in1) temp1(keep=famid sm_f) ;
by famid;
run;

proc sort data=poverty;
by hseq;
run;
proc means max noprint data=poverty;
by hseq;
var refrel2 ftype;
   output out=temp3 max=fammax typemax;
run;

data temp2;
set temp1(rename=(sm_f=sm_h));
   IF ftype=1;
run;


proc sort data=temp2;
by hseq;
run;

DATA poverty;
MERGE poverty(IN=in1) temp2(keep=hseq sm_h) temp3(keep=hseq fammax typemax);
by hseq;
   IF ftype ne 3 then sm=sm_f;
   ELSE IF ftype=3 then sm=sm_h;

   IF ftype=1 and sm=1 and fammax LE 5 and typemax=1 then smlone=1;
   ELSE smlone=0;
   
run;

*********************************************************************
Create family level variables, giving the level for those in primary 
families (ftype=1) to those in related subfamilies (ftype=3)
**********************************************************************;

proc means sum noprint data=poverty;
   by famid;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr mcaid_yes kid_0_4 wkswrk infant pot_wic_mom pawval;
   output out=temp sum=ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr
					   fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval;
run;
				
data poverty;
   merge poverty 
         temp (keep=famid ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval);
   by famid; 

   fwic_mom=MIN(fpot_wic_mom,finfant,1);

   IF famrel IN (1,2) AND sex=2 AND finfant GT 0 THEN wic_mom=1;
      ELSE wic_mom=0;
run;

data temp;
   set poverty; 
   if ftype=1;
run;

data temp;
   set temp; 
   by famid notsorted;
   if first.famid=1 then dummy=1;
   else dummy=0;
   if dummy=1;
keep lft5 ftotval fmvfs fhoussub fmvrsl fngmcare fngmcaid ftotearn fpersons frelu18;
run;

proc sort data=poverty;
by lft5;
run;
proc sort data=temp;
by lft5;
run;

data poverty;
merge poverty temp(rename=(ftotval=ftotval_new fmvfs=fmvfs_new
     fhoussub=fhoussub_new fmvrsl=fmvrsl_new 
     fngmcare=fngmcare_new fngmcaid=fngmcaid_new ftotearn=ftotearn_new fpersons=fpersons_new 
     frelu18=frelu18_new));
by lft5;

if ftype=3 then do;
  	 ftotval_final=ftotval_new;
     fmvfs_final=fmvfs_new;
         fhoussub_final=fhoussub_new; 
         fmvrsl_final=fmvrsl_new;
         fngmcare_final=fngmcare_new; 
         fngmcaid_final=fngmcaid_new;
         ftotearn_final=ftotearn_new; 
		 fpersons_final=fpersons_new;
	     frelu18_final=frelu18_new; 
end;
else if ftype ne 3 then do;
        ftotval_final=ftotval;
        fmvfs_final=fmvfs;
         fhoussub_final=fhoussub; 
         fmvrsl_final=fmvrsl;
         fngmcare_final=fngmcare; 
         fngmcaid_final=fngmcaid; 
		 ftotearn_final=ftotearn; 
		 fpersons_final=fpersons;
	     frelu18_final=frelu18; 
end;

run;

proc means sum noprint data=poverty;
by lft5;
where ftype in(1,3);
var tottax eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr mcaid_yes kid_0_4 wkswrk pawval wic_mom infant;
output out=temp sum=ftottax2 feitc2 fcapgain2 fcaploss2 femcontrb2 ftot_trans2 fssinc_rr2
					fmcaid2 fkid_0_42 fwkswrk2 fpawval2 fwic_mom2 finfant2;
run;

data poverty;
merge poverty temp (keep=lft5 ftottax2 feitc2 fcapgain2 fcaploss2 femcontrb2 ftot_trans2 fssinc_rr2
						 fmcaid2 fkid_0_42 fwkswrk2 fpawval2 fwic_mom2 finfant2);
by lft5; 

if ftype in (1,3) then do;
   ftottax_final=ftottax2;
   feitc_final=feitc2;
	fcapgain_final=fcapgain2;
     fcaploss_final=fcaploss2;
     femcontrb_final=femcontrb2;
	 ftot_trans_final=ftot_trans2;
	 fssinc_rr_final=fssinc_rr2;

	 fmcaid_final= fmcaid2;
	 fkid_0_4_final= fkid_0_42;
	 fwkswrk_final=fwkswrk2;
	 fpawval_final=fpawval2;
	 fwic_mom_final=fwic_mom2;
	 finfant_final=finfant2;
end;
else if ftype in (2,4,5) then do;
   ftottax_final=ftottax;
   feitc_final=feitc;
	fcapgain_final=fcapgain;
     fcaploss_final=fcaploss;
     femcontrb_final=femcontrb;
	 ftot_trans_final=ftot_trans;
	 fssinc_rr_final=fssinc_rr;

	 fmcaid_final= fmcaid;
	 fkid_0_4_final= fkid_0_4;
	 fwkswrk_final=fwkswrk;
	 fpawval_final=fpawval;
	 fwic_mom_final=fwic_mom;
	 finfant_final=finfant;
end;

run;

data temp;
   set poverty;
   by famid;
   if first.famid; 
run;
proc sort data=temp;
   by hseq;
run;
* exclude the related subfamilies because their values of the following are 
  already included in the values for the primary family;
proc means sum noprint data=temp;
   by hseq;
   where ftype NE 3;
   var fmvfs fhoussub fmvrsl fngmcare fngmcaid ftotearn fpersons frelu18;
   output out=temp1 sum=hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18;
run;

proc sort data=poverty;
   by hseq;
run;
proc means sum noprint data=poverty;
   by hseq;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr;
   output out=temp sum=htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr;
run;

data cpsdata.poverty1991;
   merge poverty 
         temp (keep= hseq htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr)
		 temp1 (keep=hseq hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18);
   by hseq; 
run;
proc means;
run;

proc compare base=cpsdata.poverty1991_bak
             compare=cpsdata.poverty1991
			 novalues listall
;

run;





